/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.content;

import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.IVWConfigActionListener;
import filenet.vw.toolkit.admin.VWConfigActionCommand;
import filenet.vw.toolkit.admin.VWConfigActionEvent;
import filenet.vw.toolkit.admin.VWConfigBaseNode;
import filenet.vw.toolkit.admin.VWConfigPerformer;
import filenet.vw.toolkit.admin.VWConfigRegionNode;
import filenet.vw.toolkit.admin.content.VWConfigIcon;
import filenet.vw.toolkit.admin.content.VWConfigIconViewPane;
import filenet.vw.toolkit.admin.content.VWConfigPropertyViewPane;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.EventListenerList;

public class VWConfigContentViewPane
extends JPanel
implements ActionListener,
IVWConfigActionListener {
    public static final int ICON_VIEW = 0;
    public static final int PROPERTY_VIEW = 1;
    public static final int LIST_VIEW = 2;
    protected VWConfigBaseNode m_focus = null;
    protected VWConfigPerformer m_performer = null;
    private JPanel m_currentPanel = null;
    private VWConfigIconViewPane m_iconView = null;
    private VWConfigPropertyViewPane m_propertyView = null;
    private EventListenerList m_listenerList = null;
    private int m_viewMode = 0;

    public VWConfigContentViewPane() {
        this.setDoubleBuffered(true);
        this.setLayout(new BorderLayout());
        this.m_listenerList = new EventListenerList();
    }

    public void init(VWConfigBaseNode node, int viewMode, VWConfigPerformer performer) {
        this.m_focus = node;
        this.m_performer = performer;
        this.m_iconView = new VWConfigIconViewPane(this, this.m_focus, this);
        this.m_propertyView = new VWConfigPropertyViewPane(this, this.m_focus, this);
        if (viewMode == 1) {
            this.m_currentPanel = this.m_propertyView;
            this.m_viewMode = 1;
        } else {
            this.m_currentPanel = this.m_iconView;
            this.m_viewMode = 0;
        }
        this.add((Component)new JScrollPane(this.m_currentPanel), "Center");
        ComponentOrientation compOrientation = ComponentOrientation.getOrientation(Locale.getDefault());
        this.applyComponentOrientation(compOrientation);
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        if (this.m_currentPanel != null) {
            Dimension dim = this.m_currentPanel.getPreferredSize();
            dim.setSize(width - 5, (height - 5) * 2);
            this.m_currentPanel.setPreferredSize(dim);
        }
    }

    public void setViewMode(VWConfigBaseNode node, int viewMode) {
        this.m_focus = node;
        switch (this.m_viewMode) {
            case 0: {
                this.m_currentPanel = this.m_iconView;
                break;
            }
            case 1: {
                this.m_currentPanel = this.m_propertyView;
            }
        }
        this.refreshContent();
    }

    public void refreshContent() {
        this.removeAll();
        switch (this.m_viewMode) {
            case 0: {
                this.m_iconView.displayContent(this.m_focus);
                break;
            }
            case 1: {
                this.m_propertyView.displayContent(this.m_focus);
            }
        }
        JScrollPane scrollPan = new JScrollPane(this.m_currentPanel);
        this.add((Component)scrollPan, "Center");
        ComponentOrientation compOrientation = ComponentOrientation.getOrientation(Locale.getDefault());
        this.applyComponentOrientation(compOrientation);
        this.revalidate();
        this.repaint();
    }

    public void refreshContent(VWConfigBaseNode bNode) {
        this.removeAll();
        switch (this.m_viewMode) {
            case 0: {
                this.m_iconView.displayContent(bNode);
                break;
            }
            case 1: {
                this.m_propertyView.displayContent(bNode);
            }
        }
        this.add((Component)new JScrollPane(this.m_currentPanel), "Center");
        ComponentOrientation compOrientation = ComponentOrientation.getOrientation(Locale.getDefault());
        this.applyComponentOrientation(compOrientation);
        this.revalidate();
        this.repaint();
    }

    public void requestFocus() {
        if (this.m_viewMode == 1) {
            this.m_propertyView.requestFocus();
        } else {
            this.m_iconView.requestFocus();
        }
    }

    public void requestFocus(VWConfigIcon anIcon) {
        this.requestFocus();
        this.m_iconView.requestFocus();
        this.m_iconView.requestIconFocus(anIcon);
    }

    public void addConfigActionListener(IVWConfigActionListener cal) {
        this.m_listenerList.add(IVWConfigActionListener.class, cal);
    }

    public void releaseResources() {
        if (this.m_iconView != null) {
            this.m_iconView.releaseResources();
            this.m_iconView = null;
        }
        if (this.m_propertyView != null) {
            this.m_propertyView.releaseResources();
            this.m_propertyView = null;
        }
        if (this.m_listenerList != null) {
            Object[] listeners = this.m_listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                this.m_listenerList.remove(IVWConfigActionListener.class, (IVWConfigActionListener)listeners[i + 1]);
                listeners[i] = null;
                listeners[i + 1] = null;
            }
            this.m_listenerList = null;
        }
        this.m_focus = null;
        this.m_performer = null;
        this.m_currentPanel = null;
        this.removeAll();
    }

    public void actionPerformed(ActionEvent event) {
        String actionCMD = event.getActionCommand();
        try {
            if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_LOGOFF) == 0) {
                if (this.m_performer.performLogoff(this.m_focus, true)) {
                    this.fireConfigActionEvent(new VWConfigActionEvent(this, this.m_focus, 32));
                    this.m_focus = (VWConfigBaseNode)this.m_focus.getParent();
                    this.fireConfigActionEvent(new VWConfigActionEvent(this, this.m_focus, 16));
                    this.refreshContent();
                }
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_LOGON) == 0) {
                if (this.m_performer.performLogon(this.m_focus)) {
                    this.fireConfigActionEvent(new VWConfigActionEvent(this, this.m_focus, 96));
                    this.refreshContent();
                }
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_APPSPACE_PROPERTIES) == 0) {
                this.m_performer.performAppSpaceProperty(this.m_focus);
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_COMMIT) == 0) {
                if (this.m_performer.performCommit(this.m_focus)) {
                    this.fireConfigActionEvent(new VWConfigActionEvent(this, this.m_focus, 32));
                }
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_COMPONENT_PROPERTIES) == 0) {
                this.m_performer.performComponentQueueProperty(this.m_focus);
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_COMPONENT_REGISTRATION) == 0) {
                this.m_performer.performComponentRegistration(this.m_focus);
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_CREATE_XLIFF_FILE) == 0) {
                this.m_performer.performCreateXliffFile(this.m_focus);
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_DELETE) == 0) {
                VWConfigBaseNode newFocusNode = this.m_performer.performDeleteItem(this.m_focus);
                if (newFocusNode != null) {
                    this.m_focus = newFocusNode;
                    this.fireConfigActionEvent(new VWConfigActionEvent(this, this.m_focus, 16));
                    this.fireConfigActionEvent(new VWConfigActionEvent(this, this.m_focus, 32));
                    this.refreshContent();
                }
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_DISCARD) == 0) {
                int ret;
                int nodeType = this.m_focus.getType();
                if (nodeType != 17 && nodeType != 18 && nodeType != 19) {
                    VWConfigRegionNode rNode = (VWConfigRegionNode)this.m_focus.findAncestorNode(19);
                    ret = this.m_performer.performDiscard(rNode, true, true);
                } else {
                    ret = this.m_performer.performDiscard(this.m_focus, true, true);
                }
                if (ret == 0) {
                    this.fireConfigActionEvent(new VWConfigActionEvent(this, this.m_focus, 32));
                    this.refreshContent();
                }
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_EVENTLOG_PROPERTIES) == 0) {
                this.m_performer.performEventLogProperty(this.m_focus);
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_EXPORT) == 0) {
                this.m_performer.performExport(this.m_focus);
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_IMPORT) == 0) {
                this.m_performer.performImport(this.m_focus);
                this.fireConfigActionEvent(new VWConfigActionEvent(this, this.m_focus, 32));
                this.refreshContent();
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_INITIALIZE_REGION) == 0) {
                if (this.m_performer.performInitRegion(this.m_focus)) {
                    this.fireConfigActionEvent(new VWConfigActionEvent(this, this.m_focus, 32));
                    this.m_focus = (VWConfigBaseNode)this.m_focus.getParent();
                    this.fireConfigActionEvent(new VWConfigActionEvent(this, this.m_focus, 16));
                    this.refreshContent();
                }
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_NEW_APPSPACE) == 0) {
                this.m_performer.performNewAppSpace(this.m_focus);
                this.fireConfigActionEvent(new VWConfigActionEvent(this, this.m_focus, 32));
                this.refreshContent();
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_NEW_COMPONENT) == 0) {
                this.m_performer.performNewComponent(this.m_focus);
                this.fireConfigActionEvent(new VWConfigActionEvent(this, this.m_focus, 32));
                this.refreshContent();
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_NEW_EVENTLOG) == 0) {
                this.m_performer.performNewEventLog(this.m_focus);
                this.fireConfigActionEvent(new VWConfigActionEvent(this, this.m_focus, 32));
                this.refreshContent();
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_NEW_QUEUE) == 0) {
                this.m_performer.performNewQueue(this.m_focus);
                this.fireConfigActionEvent(new VWConfigActionEvent(this, this.m_focus, 32));
                this.refreshContent();
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_NEW_ROSTER) == 0) {
                this.m_performer.performNewRoster(this.m_focus);
                this.fireConfigActionEvent(new VWConfigActionEvent(this, this.m_focus, 32));
                this.refreshContent();
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_PUBLISH_UDDI) == 0) {
                this.m_performer.performPublishToUDDI(this.m_focus);
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_PUBLISH_WSRR) == 0) {
                this.m_performer.performPublishToWSRR(this.m_focus);
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_QUEUE_PROPERTIES) == 0) {
                this.m_performer.performQueueProperty(this.m_focus);
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_REGION_PROPERTIES) == 0) {
                this.m_performer.performRegionProperties(this.m_focus);
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_REMOVE_ALL_REGIONS) == 0) {
                if (this.m_performer.performRemoveAllRegions(this.m_focus)) {
                    this.fireConfigActionEvent(new VWConfigActionEvent(this, this.m_focus, 32));
                    this.refreshContent();
                }
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_REMOVE_REGION) == 0) {
                if (this.m_performer.performRemoveRegion(this.m_focus)) {
                    this.fireConfigActionEvent(new VWConfigActionEvent(this, this.m_focus, 32));
                    this.m_focus = (VWConfigBaseNode)this.m_focus.getParent();
                    this.fireConfigActionEvent(new VWConfigActionEvent(this, this.m_focus, 16));
                    this.refreshContent();
                }
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_REMOVE_WORKFLOW_DATABASE) == 0) {
                if (this.m_performer.performRemoveWorkflowDataBase(this.m_focus)) {
                    this.fireConfigActionEvent(new VWConfigActionEvent(this, this.m_focus, 32));
                    this.refreshContent();
                }
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_ROSTER_PROPERTIES) == 0) {
                this.m_performer.performRosterProperty(this.m_focus);
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_SYSTEM_PROPERTIES) == 0) {
                this.m_performer.performVWServiceProperties(this.m_focus);
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_VERIFY_XLIFF_FILE) == 0) {
                this.m_performer.performVerifyXliffFile(this.m_focus);
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_HELP) == 0) {
                this.m_performer.performHelp(this.m_focus);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void configActionPerformed(VWConfigActionEvent evt) {
        VWConfigBaseNode baseNode = evt.getBaseNode();
        try {
            if (evt.changedFocus()) {
                this.setFocus(baseNode);
            }
            if (evt.refresh()) {
                this.refreshContent();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void changeFocus(VWConfigBaseNode node) {
        this.m_focus = node;
        this.fireConfigActionEvent(new VWConfigActionEvent(this, this.m_focus, 16));
    }

    protected void setFocus(VWConfigBaseNode node) {
        if (this.m_focus != node) {
            this.m_focus = node;
            this.refreshContent();
        }
    }

    private void fireConfigActionEvent(VWConfigActionEvent evt) {
        if (evt == null) {
            return;
        }
        Object[] listeners = this.m_listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != IVWConfigActionListener.class) continue;
            ((IVWConfigActionListener)listeners[i + 1]).configActionPerformed(evt);
        }
    }
}

